/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ruby.debug.ui.launcher;

import com.aptana.ruby.debug.ui.launcher.Messages;
import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ResourceListSelectionDialog;

public class RubyMainTab
extends AbstractLaunchConfigurationTab {
    private Text fProgramText;
    private Button fProgramButton;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        topLayout.verticalSpacing = 0;
        topLayout.numColumns = 3;
        comp.setLayout((Layout)topLayout);
        comp.setFont(font);
        this.createVerticalSpacer(comp, 3);
        Label programLabel = new Label(comp, 0);
        programLabel.setText(Messages.RubyMainTab_FileLabel);
        GridData gd = new GridData(1);
        programLabel.setLayoutData((Object)gd);
        programLabel.setFont(font);
        this.fProgramText = new Text(comp, 2052);
        gd = new GridData(768);
        this.fProgramText.setLayoutData((Object)gd);
        this.fProgramText.setFont(font);
        this.fProgramText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RubyMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fProgramButton = this.createPushButton(comp, "&Browse...", null);
        this.fProgramButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RubyMainTab.this.browseRubyFiles();
            }
        });
    }

    protected void browseRubyFiles() {
        ResourceListSelectionDialog dialog = new ResourceListSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
        dialog.setTitle(Messages.RubyMainTab_OpenFileDialogTitle);
        dialog.setMessage(Messages.RubyMainTab_OpenFileDialogMessage);
        if (dialog.open() == 0) {
            Object[] files = dialog.getResult();
            IFile file = (IFile)files[0];
            this.fProgramText.setText(file.getFullPath().toString());
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String program = configuration.getAttribute("com.aptana.ruby.debug.ATTR_FILE_NAME", null);
            if (program != null) {
                this.fProgramText.setText(program);
            }
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String program = this.fProgramText.getText().trim();
        if (program.length() == 0) {
            program = null;
        }
        configuration.setAttribute("com.aptana.ruby.debug.ATTR_FILE_NAME", program);
    }

    public String getName() {
        return Messages.RubyMainTab_Name;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        String text = this.fProgramText.getText();
        if (text.length() > 0) {
            File aFile = new File(text);
            if (!aFile.exists() || aFile.isDirectory()) {
                IFile file = null;
                try {
                    file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(text));
                }
                catch (Exception exception) {}
                if (file == null || !file.exists()) {
                    this.setErrorMessage(Messages.RubyMainTab_FileDoesntExistError);
                    return false;
                }
            }
            this.setErrorMessage(null);
            this.setMessage(null);
        } else {
            this.setMessage(Messages.RubyMainTab_EmptyFileError);
        }
        return super.isValid(launchConfig);
    }
}

